/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.AnalogMathsParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.util.Language;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;

public class MathDetectionParameter
extends ProtectionParameter {
    private static final long serialVersionUID = -4264667983050884301L;
    private int blockSerializedDataVersion = 1;
    private int fReferencedBlockNumber = -1;
    private boolean fAutoResetMode;
    private boolean fDetectZeroDivision;
    private boolean fDetectOverflow;
    private transient boolean fZeroDivision;
    private transient boolean fOverflow;
    public static final transient String BOTH = "0";
    public static final transient String ZERO_DIVISION = "1";
    public static final transient String OVERFLOW = "2";

    public MathDetectionParameter() {
    }

    public MathDetectionParameter(Block block) {
        super(block);
        this.setRemanenceAvailable(true);
        this.fDetectZeroDivision = true;
        this.fDetectOverflow = true;
    }

    public int getReferencedBlockNumber() {
        return this.fReferencedBlockNumber;
    }

    public void setReferencedBlockNumber(int blockNr) {
        this.fReferencedBlockNumber = blockNr;
    }

    public void setReferencedBlockName(String blockName) {
        this.setReferencedBlockNumber(Integer.valueOf(blockName));
    }

    public String getReferencedBlockName() {
        if (this.fReferencedBlockNumber == -1) {
            return "----";
        }
        return this.getBlock().getWiringDiagram().getBlock(68, this.fReferencedBlockNumber).getNumberString();
    }

    public Boolean isAutoResetMode() {
        return this.fAutoResetMode;
    }

    public void setAutoResetMode(Boolean autoResetMode) {
        this.fAutoResetMode = autoResetMode;
    }

    public boolean isDetectZeroDivision() {
        return this.fDetectZeroDivision;
    }

    public boolean isDetectOverflow() {
        return this.fDetectOverflow;
    }

    public void setDetectZeroDivision(boolean detectZeroDivision) {
        this.fDetectZeroDivision = detectZeroDivision;
    }

    public void setDetectOverflow(boolean detectOverflow) {
        this.fDetectOverflow = detectOverflow;
    }

    public String getParameterText() {
        StringBuffer buffer = new StringBuffer(super.getParameterText());
        if (buffer.length() > 0) {
            buffer.append("\n");
        }
        buffer.append("Source=");
        if (this.fReferencedBlockNumber > 0) {
            buffer.append("B").append(this.fReferencedBlockNumber);
        } else {
            buffer.append("null");
        }
        buffer.append(this.getProtectionSign());
        buffer.append("\nZero div=").append(this.fDetectZeroDivision ? "Y" : "N");
        buffer.append("\nOverflow=").append(this.fDetectOverflow ? "Y" : "N");
        buffer.append("\nAuto Rst=").append(this.fAutoResetMode ? "Y" : "N");
        return buffer.toString();
    }

    public String calculateCurrentParameterText() {
        return MathDetectionParameter.getStateText(this.fZeroDivision, this.fOverflow);
    }

    public static String getStateText(boolean zeroDivision, boolean overflow) {
        StringBuffer buffer = new StringBuffer();
        if (zeroDivision) {
            buffer.append("Zero_div");
        }
        if (overflow) {
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append("Overflow");
        }
        if (buffer.length() == 0) {
            buffer.append("No Error");
        }
        return buffer.toString();
    }

    public final boolean getValue(boolean en, boolean rst) {
        boolean result = false;
        Block block = this.getBlock().getWiringDiagram().getExpansionBlockByOpcode(68, this.fReferencedBlockNumber);
        if (block instanceof AnalogMathsBlock && !rst) {
            AnalogMathsParameter param = (AnalogMathsParameter)block.getParameter();
            if (this.fAutoResetMode) {
                if (en) {
                    this.fZeroDivision = param.isZeroDivision() && this.fDetectZeroDivision;
                    this.fOverflow = param.isOverflow() && this.fDetectOverflow;
                } else {
                    this.resetErrorStatus();
                }
            } else if (en) {
                this.fZeroDivision |= param.isZeroDivision() && this.fDetectZeroDivision;
                this.fOverflow |= param.isOverflow() && this.fDetectOverflow;
            }
            result = en ? this.fZeroDivision || this.fOverflow : false;
        } else {
            this.resetErrorStatus();
            result = false;
        }
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fReferencedBlockNumber = dr.readInt();
        this.fDetectZeroDivision = dr.readBoolean();
        this.fDetectOverflow = dr.readBoolean();
        this.fAutoResetMode = dr.readBoolean();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fReferencedBlockNumber);
        dw.writeBoolean(this.fDetectZeroDivision);
        dw.writeBoolean(this.fDetectOverflow);
        dw.writeBoolean(this.fAutoResetMode);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.blockSerializedDataVersion = 1;
        s.defaultWriteObject();
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        return super.isAvailable(hardware, errorList);
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence() || forceReset) {
            this.resetErrorStatus();
        }
    }

    public void resetErrorStatus() {
        this.fZeroDivision = false;
        this.fOverflow = false;
    }

    public int isOverflow() {
        return this.fOverflow ? 1 : 0;
    }

    public int isZeroDivision() {
        return this.fZeroDivision ? 1 : 0;
    }

    public String getErrorToDetect() {
        if (this.fDetectZeroDivision && this.fDetectOverflow) {
            return Language.getString("dialog.parameter.mathDetection.Both", "Both");
        }
        if (this.fDetectZeroDivision) {
            return Language.getString("dialog.parameter.mathDetection.ZeroDiv", "zero division");
        }
        return Language.getString("dialog.parameter.mathDetection.Overflow", "overflow");
    }

    public void setErrorToDetect(String error) {
        if (error.equals(BOTH)) {
            this.setDetectOverflow(true);
            this.setDetectZeroDivision(true);
        } else if (error.equals(ZERO_DIVISION)) {
            this.setDetectZeroDivision(true);
            this.setDetectOverflow(false);
        } else {
            this.setDetectOverflow(true);
            this.setDetectZeroDivision(false);
        }
    }

    public void deleteReferencesToParameterItem(HashMap resultDict) {
        super.deleteReferencesToParameterItem(resultDict);
        this.setReferencedBlockNumber(-1);
    }
}

